//==============================================================================
// Project:		Wealth Transfers and their economic effects
// File name:	Nolan other comparison
// Objective: 	Generate figure B.8 and the figure 2.6/table B.7 statistic that is compared with Nolan et al.'s research of countries other than Britain
//
//==============================================================================


clear all

************************
*** Data import ***
************************

cd "XXXX" //set content directory here

use combined_filtered_restricted.dta, replace

merge m:1 xwaveid wave using bequest_from_HH_death.dta //flag for inheritances due to HH deaths
drop if _merge == 2
drop _merge

merge m:1 wave using CPI.dta //CPI data
drop if _merge == 2
drop _merge 

xtset xwaveid wave

drop if hgint == 0 //drop non-responders

************************
*** Create variables ***
************************

replace oifinha = 0 if oifinha == -1 //inheritances
replace oifinha = . if oifinha < 0
gen bequest = oifinha
replace bequest = 0 if bequest > 0 & bequest != . & bequest_from_HH_death == 1 //filter out inheritances due to first estates

replace oifnptr = . if oifnptr < 0 //gifts
gen gift = oifnptr + oifnpt
 
replace hwnwip = hwnwip * 100/CPI //convert to real values
replace hwnwin = hwnwin * 100/CPI
replace hwsupei = hwsupei * 100/CPI //HH superannuation balances
replace bequest = bequest * 100/CPI
replace gift = gift * 100/CPI

gen transfer_1 = bequest + gift
forvalues x = 2/18{
	local y = `x' - 1
	gen transfer_`x' = transfer_`y' + L`y'.bequest + L`y'.gift  
}

drop if transfer_18 == .
drop if wlra_r == 0 //Responding person longitudinal weight - Balanced W1 to W18
drop if wave != 18

local HH_transfers
forvalues x = 1/18{
	egen transfer_`x'_HH = total(transfer_`x'), by(hhrhid)
	local HH_transfers `HH_transfers' transfer_`x'_HH
}

gen net_worth_plus_transfer = hwnwip - hwnwin - hwsupei //exclude superannuation to match the approach of Nolan et al.
local net_worths
forvalues x = 1/18{
replace transfer_`x'_HH = net_worth_plus_transfer if transfer_`x'_HH > net_worth_plus_transfer //to match approach of Nolan et al. (the Piketty method)
replace transfer_`x'_HH = 0 if transfer_`x'_HH < 0
gen net_worth_`x' = net_worth_plus_transfer - transfer_`x'_HH
local net_worths `net_worths' net_worth_`x'
}

collapse (mean) `HH_transfers' `net_worths' net_worth_plus_transfer wlra_r, by(hhrhid)

************************
*** Calculate Ginis ****
************************

forvalues x = 1/18{ //x=18 value is the Australian statistics in table B.8
sgini net_worth_`x' transfer_`x'_HH [pweight = wlra_r], source
matrix Gini_`x' = r(coeffs)
matrix Corr_`x' = r(r)
matrix Share_`x' = r(s)
}

clear

forvalues x = 1/18{
svmat Gini_`x', names(col)
rename net_worth_`x' Gini_net_worth_`x'
rename transfer_`x'_HH Gini_transfer_HH_`x'
drop _factotal
svmat Corr_`x', names(col)
rename net_worth_`x' Corr_net_worth_`x'
rename transfer_`x'_HH Corr_transfer_HH_`x'
svmat Share_`x', names(col)
rename net_worth_`x' Share_net_worth_`x'
rename transfer_`x'_HH Share_transfer_HH_`x'
}

gen flag = 1

reshape long Gini_net_worth_ Gini_transfer_HH_  Corr_net_worth_ Corr_transfer_HH_  Share_net_worth_ Share_transfer_HH_ , i(flag) j(years)

gen effect = ((Share_transfer_HH_ * Corr_transfer_HH_ * Gini_transfer_HH_ + Share_net_worth_ * Corr_net_worth_ * Gini_net_worth_) - Gini_net_worth_) * 100 / Gini_net_worth_

gen neg_effect = - effect

export delim Nolan_comparison.csv, replace  //figure B.8; wave 18 value is reported in table B.7 and figure 2.6

